<?php

namespace Ignite\Vendor\Helix\Laravel\Services;

class Token
{
    /**
     * Encrypt the user id to create the access token.
     *
     * @param int $userId
     * @param bool $encoded
     *
     * @return string
     */
    public function encrypt($userId, $encoded = true)
    {
        $catalogId = config('helix.catalog');
        $key = base64_decode(config('helix.token.key'));
        $iv = base64_decode(config('helix.token.iv'));
        $algo = config('helix.token.algorithm');
        $token = openssl_encrypt($catalogId . $userId, $algo, hex2bin($key), OPENSSL_RAW_DATA);

        return $encoded ? base64_encode($token) : $token;
    }

    /**
     * Decrypt the access token and find the user id.
     *
     * @param string $token
     * @param bool $encoded
     *
     * @return int
     */
    public function decrypt($token, $encoded = true)
    {
        $token = $encoded ? base64_decode($token, true) : $token;
        $catalogId = config('helix.catalog');
        $key = base64_decode(config('helix.token.key'));
        $iv = base64_decode(config('helix.token.iv'));
        $algo = config('helix.token.algorithm');
        $source = openssl_decrypt($token, $algo, hex2bin($key), OPENSSL_RAW_DATA);

        return str_replace($catalogId, '', $source);
    }
}
