<?php

namespace Ignite\Vendor\Helix\Laravel\Response\Tests;

use Ignite\Vendor\Helix\Laravel\Response;
use Ignite\Vendor\Helix\Tests\TestCase;
use Illuminate\Support\Collection;

class ResponseTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_determine_the_status_of_the_response()
    {
        $response = new Response([
            'status' => 'error'
        ]);

        $this->assertEquals('error', $response->status());
    }

    /**
     * @test
     */
    public function it_can_determine_whether_the_request_passed()
    {
        $response = new Response([
            'status' => 'success'
        ]);

        $this->assertTrue($response->passed());
    }

    /**
     * @test
     */
    public function it_can_determine_whether_the_request_failed()
    {
        $response = new Response([
            'status' => 'error'
        ]);

        $this->assertTrue($response->failed());
    }

    /**
     * @test
     */
    public function it_can_get_the_response_message()
    {
        $response = new Response([
            'message' => 'Success'
        ]);

        $this->assertEquals('Success', $response->message());
    }

    /**
     * @test
     */
    public function it_can_get_an_arbitrary_response_value_by_key()
    {
        $response = new Response([
            'COMMANDE_ID' => 123131
        ]);

        $this->assertEquals(123131, $response->get('COMMANDE_ID'));
    }

    /**
     * @test
     */
    public function it_can_get_a_default_value_when_an_arbitrary_response_value_by_key_is_missing()
    {
        $response = new Response([]);

        $this->assertEquals('foo', $response->get('COMMANDE_ID', 'foo'));
    }

    /**
     * @test
     */
    public function it_can_transform_response_data_to_collection()
    {
        $response = new Response([
            'data' => [
                [
                    'productId' => 5340,
                    'productNumber' => 'EL11514U',
                    'productModel' => '316238',
                ]
            ]
        ]);

        $this->assertInstanceOf(Collection::class, $response->data());
    }

    /**
     * @test
     */
    public function it_will_proxy_methods_to_the_underlying_data_collection()
    {
        $response = new Response([
            'data' => [
                [
                    'productId' => 5340,
                    'productNumber' => 'EL11514U',
                    'productModel' => '316238',
                ]
            ]
        ]);

        $proxy = $response->pluck('productModel');
        $this->assertInstanceOf(Collection::class, $proxy);
        $this->assertEquals('316238', $proxy->first());
    }

    /**
     * @test
     * @expectedException \Exception
     */
    public function it_will_throw_an_exception_when_cannot_proxy_methods_to_the_underlying_data_collection()
    {
        $response = new Response([
            'data' => [
                [
                    'productId' => 5340,
                    'productNumber' => 'EL11514U',
                    'productModel' => '316238',
                ]
            ]
        ]);

        $proxy = $response->foo();
    }
}
