<?php

namespace Ignite\Vendor\Helix\Laravel\Services;

class Token
{
    /**
     * Encrypt the user id to create the access token.
     *
     * @param int $userId
     * @param bool $encoded
     *
     * @return string
     */
    public function encrypt($userId, $encoded = true)
    {
        $catalogId = config('helix.catalog');
        $key = config('helix.token.key');
        $iv = config('helix.token.iv');
        $algo = config('helix.token.algorithm');
        $token = bin2hex(
            openssl_encrypt($catalogId . $userId, $algo, $key, OPENSSL_RAW_DATA, $iv)
        );

        return $encoded ? base64_encode($token) : $token;
    }

    /**
     * Decrypt the access token and find the user id.
     *
     * @param string $token
     * @param bool $encoded
     *
     * @return int
     */
    public function decrypt($token, $encoded = true)
    {
        $token = $encoded ? base64_decode($token, true) : $token;
        $catalogId = config('helix.catalog');
        $key = config('helix.token.key');
        $iv = config('helix.token.iv');
        $algo = config('helix.token.algorithm');
        $source = bin2hex(
            openssl_decrypt($token, $algo, $key, OPENSSL_RAW_DATA, $iv)
        );

        return str_replace($catalogId, '', $source);
    }
}
