<?php

namespace Ignite\Vendor\Hawk;

class Recipient extends Model
{
    /**
     * @var string
     */
    protected $id;

    /**
     * Create an instance from an associative array, assuming that array has the required keys.
     *
     * @param  array $data
     * @return $this
     */
    public static function fromAssociativeArray($data)
    {
        return app(static::class, $data);
    }

    /**
     * Recipient constructor.
     *
     * @param null|string            $id
     */
    public function __construct($id = null) {
        $this->setId($id);
    }

    /**
     * Set the ID.
     *
     * @param  string $id
     * @return $this
     */
    private function setId($id)
    {
        if (! is_null($id)) {
            $this->guardAgainstMaxLength('id', $id, 30);
        }

        $this->id = $id;

        return $this;
    }

    /**
     * Get the instance as an array.
     *
     * @return array
     */
    public function toArray()
    {
        return array_filter(parent::toArray());
    }
}
