<?php

namespace Ignite\Vendor\Hawk\Tests;

use Ignite\Vendor\Hawk\ClosedLoopAnonymousOrderLine;
use Ignite\Vendor\Hawk\ShippingMethod;
use PHPUnit\Framework\TestCase;

class ClosedLoopAnonymousOrderLineTest extends TestCase
{
    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_create_an_instance_from_an_associated_array()
    {
        $data = [
            'amount' => 25,
            'quantity' => 1,
            'deliveryAddress' => [
                'company' => 'Brightspot',
                'line1' => '102 Decker Ct',
                'city' => 'Irving',
                'region' => 'TX',
                'postalCode' => '75062',
                'country' => 'US',
                'line2' => '',
                'line3' => '',
                'postalCodeExt' => ''
            ],
            'contentProvider' => 'Target',
            'id' => '93066511',
            'description' => 'description',
            'shippingMethod' => ShippingMethod::UPS_GROUND,
            'cardCarrierMessage' => '',
            'fourthLineEmbossText' => '',
            'additionalInfo' => []
        ];

        $orderLine = ClosedLoopAnonymousOrderLine::fromAssociativeArray($data);

        $this->assertEquals([
            'amount' => 25,
            'quantity' => 1,
            'deliveryAddress' => [
                'company' => 'Brightspot',
                'line1' => '102 Decker Ct',
                'city' => 'Irving',
                'region' => 'TX',
                'postalCode' => '75062',
                'country' => 'US',
            ],
            'contentProvider' => 'Target',
            'id' => '93066511',
            'description' => 'description',
            'shippingMethod' => ShippingMethod::UPS_GROUND,
        ], $orderLine->toArray());
    }
}
