<?php

namespace Ignite\Vendor\Hawk\Response;

use Ignite\Vendor\Hawk\Request\SubmitVirtualIndividualRequest;

/**
 * Class SubmitVirtualIndividualTransactionResponse
 *
 * @method string getStartTime()
 * @method string getCompletionTime()
 * @method string getVersionId()
 * @method string getStatus()
 * @method bool getIsReversible()
 * @method bool getWasReversed()
 * @method array getContext()
 * @method int getStepsCompleted()
 * @method bool getSteps()
 */
class SubmitVirtualIndividualTransactionResponse extends TransactionResponse
{
    /**
     * The SubmitVirtualIndividualResponse instance.
     *
     * @return SubmitVirtualIndividualResponse
     */
    public function getResponse()
    {
        return app(SubmitVirtualIndividualResponse::class, $this->data['response']);
    }

    /**
     * The SubmitVirtualIndividualRequest instance.
     *
     * @return SubmitVirtualIndividualRequest
     */
    public function getRequest()
    {
        return app(SubmitVirtualIndividualRequest::class, $this->data['request']);
    }
}
