<?php

namespace Ignite\Vendor\Hawk\Tests\Response;

use Ignite\Vendor\Hawk\ClosedLoopIndividualOrderLine;
use Ignite\Vendor\Hawk\PaymentType;
use Ignite\Vendor\Hawk\Request\SubmitClosedLoopIndividualRequest;
use PHPUnit\Framework\TestCase;

class SubmitClosedLoopIndividualRequestTest extends TestCase
{
    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_provides_the_correct_array_data_for_request()
    {
        $input = [
            'orderDetails' => [
                ClosedLoopIndividualOrderLine::fromAssociativeArray([
                    'amount' => 25,
                    'contentProvider' => 'Target_eGift',
                    'recipient' => [
                        'firstName' => 'John',
                        'lastName' => 'Smith',
                        'address' => [
                            'line1' => '102 Decker Ct',
                            'city' => 'Irving',
                            'region' => 'TX',
                            'postalCode' => '75062',
                            'country' => 'USA',
                        ]
                    ]
                ])
            ],
            'clientProgramNumber'=> '123123123',
            'paymentType' => PaymentType::DRAW_DOWN,
        ];

        $request = new SubmitClosedLoopIndividualRequest(
            $input['orderDetails'],
            $input['clientProgramNumber'],
            $input['paymentType']
        );

        $output = $request->toArray();

        $this->assertInternalType('array', $output['orderDetails']);
        $this->assertNotEmpty($output['orderDetails']);
        $this->assertSame('123123123', $output['clientProgramNumber']);
        $this->assertSame(PaymentType::DRAW_DOWN, $output['paymentType']);
        $this->assertSame('Target_eGift', $output['orderDetails'][0]['contentProvider']);
    }
}