<?php

namespace Ignite\Vendor\Hawk;

class ShippingMethod extends Model
{
    const USPS_FIRST_CLASS = 'USPS_FIRST_CLASS';
    const USPS_STANDARD_MAIL = 'USPS_STANDARD_MAIL';
    const UPS_SECOND_DAY = 'UPS_SECOND_DAY';
    const UPS_NEXT_DAY = 'UPS_NEXT_DAY';
    const DHL_INTERNATIONAL = 'DHL_INTERNATIONAL';
    const UPS_GROUND = 'UPS_GROUND';
    const USPS_SECOND_DAY = 'USPS_SECOND_DAY';
    const USPS_NEXT_DAY = 'USPS_NEXT_DAY';
    const USPS_PRIORITY_MAIL = 'USPS_PRIORITY_MAIL';

    /**
     * The supported shipping methods as an associative array.
     *
     * @return array
     */
    public function toArray()
    {
        return static::getShippingMethods();
    }

    /**
     * Determine if the given method is an acceptable shipping method.
     *
     * @param  string $method
     * @return bool
     */
    public static function accepts($method)
    {
        return in_array($method, static::getShippingMethods());
    }

    /**
     * The delivery methods.
     *
     * @return array
     */
    public static function getShippingMethods()
    {
        return [
            static::USPS_FIRST_CLASS => static::USPS_FIRST_CLASS,
            static::USPS_STANDARD_MAIL => static::USPS_STANDARD_MAIL,
            static::UPS_SECOND_DAY => static::UPS_SECOND_DAY,
            static::UPS_NEXT_DAY => static::UPS_NEXT_DAY,
            static::DHL_INTERNATIONAL => static::DHL_INTERNATIONAL,
            static::UPS_GROUND => static::UPS_GROUND,
            static::USPS_SECOND_DAY => static::USPS_SECOND_DAY,
            static::USPS_NEXT_DAY => static::USPS_NEXT_DAY,
            static::USPS_PRIORITY_MAIL => static::USPS_PRIORITY_MAIL,
        ];
    }
}
