<?php

namespace Ignite\Vendor\Hawk;

class VirtualRecipient extends Model
{
    /**
     * @var string
     */
    protected $firstName;

    /**
     * @var string
     */
    protected $lastName;

    /**
     * @var string
     */
    protected $email;

    /**
     * @var int|null
     */
    protected $id;

    /**
     * VirtualRecipient constructor.
     *
     * @param string      $firstName
     * @param string      $lastName
     * @param string      $email
     * @param string|null $id
     */
    public function __construct($firstName, $lastName, $email, $id = null)
    {
        $this->setFirstName($firstName);
        $this->setLastName($lastName);
        $this->setEmail($email);
        $this->setId($id);
    }

    /**
     * Create a new instance from an associative array.
     *
     * @param  array $data
     * @return static
     */
    public static function fromAssociativeArray(array $data)
    {
        return app(static::class, $data);
    }

    /**
     * Set the first name.
     *
     * @param  string $firstName
     * @return $this
     */
    private function setFirstName($firstName)
    {
        $this->guardAgainstMaxLength('firstName', $firstName, 50);

        $this->firstName = $firstName;

        return $this;
    }

    /**
     * Set the last name.
     *
     * @param  string $lastName
     * @return $this
     */
    private function setLastName($lastName)
    {
        $this->guardAgainstMaxLength('lastName', $lastName, 50);

        $this->lastName = $lastName;

        return $this;
    }

    /**
     * Set the email.
     *
     * @param  string $email
     * @return $this
     */
    private function setEmail($email)
    {
        $this->guardAgainstMaxLength('email', $email, 90);
        $this->guardAgainstInvalidEmail($email);

        $this->email = $email;

        return $this;
    }

    /**
     * Set the ID.
     *
     * @param  null|string $id
     * @return $this
     */
    private function setId($id = null)
    {
        if (! is_null($id)) {
            $this->guardAgainstMaxLength('id', $id, 30);
        }

        $this->id = $id;

        return $this;
    }
}
