<?php

namespace Ignite\Vendor\Hawk;

class Ssl extends Model
{
    /** @var string */
    protected $certPath;

    /** @var string */
    protected $keyPath;

    /**
     * Ssl constructor.
     *
     * @param string $certPath
     * @param string $keyPath
     */
    public function __construct($certPath, $keyPath)
    {
        if (! is_file($certPath)) {
            throw new \InvalidArgumentException("Invalid ssl cert location: $certPath");
        }

        if (! is_file($keyPath)) {
            throw new \InvalidArgumentException("Invalid ssl key location: $keyPath");
        }

        $this->certPath = $certPath;
        $this->keyPath = $keyPath;
    }

    /**
     * Get the SSL path for use with the HTTP Client.
     *
     * @return array
     */
    public function forHttpClient()
    {
        return [$this->certPath, $this->keyPath];
    }

    /**
     * The path to the cert.
     *
     * @return string
     */
    public function getCertPath()
    {
        return $this->certPath;
    }

    /**
     * The path to the key.
     *
     * @return string
     */
    public function getKeyPath()
    {
        return $this->keyPath;
    }
}
