<?php

namespace Ignite\Vendor\Hawk\Response;

use Ignite\Vendor\Hawk\Request\SubmitOpenLoopAnonymousRequest;

/**
 * Class SubmitOpenLoopPersonalizedIndividualTransactionRequest
 *
 * @method string getStartTime()
 * @method string getCompletionTime()
 * @method string getVersionId()
 * @method string getStatus()
 * @method bool getIsReversible()
 * @method bool getWasReversed()
 * @method array getContext()
 * @method int getStepsCompleted()
 * @method bool getSteps()
 */
class SubmitOpenLoopAnonymousTransactionResponse extends SubmitOpenLoopAnonymousResponse
{
    /**
     * The SubmitOpenLoopPersonalizedIndividualResponse instance.
     *
     * @return SubmitOpenLoopAnonymousResponse
     */
    public function getResponse()
    {
        return app(SubmitOpenLoopPersonalizedIndividualResponse::class, $this->data['response']);
    }

    /**
     * The SubmitOpenLoopAnonymousRequest instance.
     *
     * @return SubmitOpenLoopAnonymousRequest
     */
    public function getRequest()
    {
        return app(SubmitOpenLoopAnonymousRequest::class, $this->data['request']);
    }
}
