<?php

namespace Ignite\Vendor\Hawk\Response;

use Ignite\Vendor\Hawk\Request\SubmitFundingRequest;

/**
 * Class SubmitFundingTransactionResponse
 *
 * @method string getStartTime()
 * @method string getCompletionTime()
 * @method string getVersionId()
 * @method string getStatus()
 * @method bool getIsReversible()
 * @method bool getWasReversed()
 * @method array getContext()
 * @method int getStepsCompleted()
 * @method bool getSteps()
 */
class SubmitFundingTransactionResponse extends TransactionResponse
{
    /**
     * The SubmitEGiftIndividualResponse instance.
     *
     * @return SubmitFundingResponse
     */
    public function getResponse()
    {
        return app(SubmitFundingResponse::class, $this->data['response']);
    }

    /**
     * The SubmitFundingRequest instance.
     *
     * @return SubmitFundingRequest
     */
    public function getRequest()
    {
        return app(SubmitFundingRequest::class, $this->data['request']);
    }
}
