<?php

namespace Ignite\Vendor\Hawk\Response;

use Ignite\Vendor\Hawk\Request\SubmitClosedLoopIndividualRequest;

/**
 * Class SubmitClosedLoopIndividualTransactionResponse
 *
 * @method string getStartTime()
 * @method string getCompletionTime()
 * @method string getVersionId()
 * @method string getStatus()
 * @method bool getIsReversible()
 * @method bool getWasReversed()
 * @method array getContext()
 * @method int getStepsCompleted()
 * @method bool getSteps()
 */
class SubmitClosedLoopIndividualTransactionResponse extends TransactionResponse
{
    /**
     * The SubmitClosedLoopIndividualResponse instance.
     *
     * @return SubmitClosedLoopIndividualResponse
     */
    public function getResponse()
    {
        return app(SubmitClosedLoopIndividualResponse::class, $this->data['response']);
    }

    /**
     * The SubmitClosedLoopIndividualRequest instance.
     *
     * @return SubmitClosedLoopIndividualRequest
     */
    public function getRequest()
    {
        return app(SubmitClosedLoopIndividualRequest::class, $this->data['request']);
    }
}
