<?php

namespace Ignite\Vendor\Hawk\Response;

use Ignite\Vendor\Hawk\ResponseException;
use Ignite\Vendor\Hawk\Status;
use Illuminate\Contracts\Support\Arrayable;
use Psr\Http\Message\ResponseInterface;

/**
 * Class ClientProgramResponse
 *
 * @method int getClientProgramId()
 * @method string getProgramName()
 * @method string getProgramType()
 * @method string getCurrency()
 * @method array getProducts()
 */
class ClientProgramResponse extends Response implements Arrayable
{
    /**
     * @var int
     */
    protected $clientProgramId;

    /**
     * @var string
     */
    protected $programName;

    /**
     * @var string
     */
    protected $programType;

    /**
     * @var string
     */
    protected $currency;

    /**
     * @var array
     */
    protected $products;

    /**
     * Create an instance from a Http Response.
     *
     * @param ResponseInterface $response
     * @return SubmitEGiftIndividualTransactionResponse|static
     * @throws ResponseException
     */
    public static function fromHttpResponse(ResponseInterface $response)
    {
        $data = static::parseJson($response);

        if (! isset($data['clientProgramId'])) {
            throw new ResponseException($response, 'Unable to find key `clientProgramId`.');
        }

        if (! isset($data['programName'])) {
            throw new ResponseException($response, 'Unable to find key `programName`.');
        }

        if (! isset($data['programType'])) {
            throw new ResponseException($response, 'Unable to find key `programType`.');
        }

        if (! isset($data['currency'])) {
            throw new ResponseException($response, 'Unable to find key `currency`.');
        }

        if (! isset($data['products'])) {
            $data['products'] = [];
        }

        return app(static::class, $data)->setHttpResponse($response);
    }

    /**
     * ClientProgramResponse constructor.
     *
     * @param int $clientProgramId
     * @param string $programName
     * @param string $programType
     * @param string $currency
     * @param array $products
     */
    public function __construct(
        int $clientProgramId,
        string $programName,
        string $programType,
        string $currency,
        array $products
    ) {
        $this->clientProgramId = $clientProgramId;
        $this->programName = $programName;
        $this->programType = $programType;
        $this->currency = $currency;
        $this->products = $products;
    }
}
