<?php

namespace Ignite\Vendor\Hawk\Tests;

use Ignite\Vendor\Hawk\DeliveryAddress;
use PHPUnit\Framework\TestCase;

class DeliveryAddressTest extends TestCase
{
    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_create_an_instance_from_an_associated_array()
    {
        $data = [
            'company' => 'Brightspot',
            'line1' => '102 Decker Ct',
            'city' => 'Irving',
            'region' => 'TX',
            'postalCode' => '75062',
            'country' => 'US',
            'line2' => '',
            'line3' => '',
            'postalCodeExt' => ''
        ];

        $address = DeliveryAddress::fromAssociativeArray($data);

        $this->assertEquals('Brightspot', $address->getCompany());
        $this->assertFalse($address->hasPostalCodeExt());
    }
}
