<?php

namespace Ignite\Vendor\Hawk;

class Status extends Model
{
    const QUEUED = 'QUEUED';
    const PROCESSING = 'PROCESSING';
    const COMPLETED = 'COMPLETED';
    const FAILED = 'FAILED';

    /**
     * The supported payment methods as an associative array.
     *
     * @return array
     */
    public function toArray()
    {
        return static::getPaymentTypes();
    }

    /**
     * Get the payment types.
     *
     * @return array
     */
    public static function getStatuses()
    {
        return [
            static::QUEUED => static::QUEUED,
            static::PROCESSING => static::PROCESSING,
            static::COMPLETED => static::COMPLETED,
            static::FAILED => static::FAILED,
        ];
    }
}
