<?php

namespace Ignite\Vendor\Hawk\Response;

use Ignite\Vendor\Hawk\Request\SubmitOpenLoopPersonalizedIndividualRequest;

/**
 * Class SubmitOpenLoopPersonalizedIndividualTransactionResponse
 *
 * @method string getStartTime()
 * @method string getCompletionTime()
 * @method string getVersionId()
 * @method string getStatus()
 * @method bool getIsReversible()
 * @method bool getWasReversed()
 * @method array getContext()
 * @method int getStepsCompleted()
 * @method bool getSteps()
 */
class SubmitOpenLoopPersonalizedIndividualTransactionResponse extends TransactionResponse
{
    /**
     * The SubmitClosedLoopIndividualResponse instance.
     *
     * @return SubmitClosedLoopIndividualResponse
     */
    public function getResponse()
    {
        return app(SubmitOpenLoopPersonalizedIndividualResponse::class, $this->data['response']);
    }

    /**
     * The SubmitOpenLoopPersonalizedIndividualRequest instance.
     *
     * @return SubmitOpenLoopPersonalizedIndividualRequest
     */
    public function getRequest()
    {
        return app(SubmitOpenLoopPersonalizedIndividualRequest::class, $this->data['request']);
    }
}
