<?php

namespace Ignite\Vendor\Hawk;

class ClosedLoopBulkOrderLine extends ClosedLoopIndividualOrderLine
{
    /** @var int */
    protected $quantity;

    /**
     * @var DeliveryAddress
     */
    protected $deliveryAddress;

    /**
     * ClosedLoopBulkOrderLine constructor.
     *
     * @param array  $recipient
     * @param string $amount
     * @param string $quantity,
     * @param array  $deliveryAddress
     * @param string $contentProvider
     * @param string $description
     * @param string $groupingId
     * @param string $shippingMethod
     * @param string $cardCarrierMessage
     * @param string $fourthLineEmbossText
     * @param array  $additionalInfo
     */
    public function __construct(
        $recipient,
        $amount,
        $quantity,
        $deliveryAddress,
        $contentProvider = null,
        $description = null,
        $groupingId = null,
        $shippingMethod = ShippingMethod::USPS_PRIORITY_MAIL,
        $cardCarrierMessage = null,
        $fourthLineEmbossText = null,
        array $additionalInfo = []
    ) {
        parent::__construct(
            $recipient, $amount, $contentProvider, $description, $groupingId, $shippingMethod,
            $cardCarrierMessage, $fourthLineEmbossText, $additionalInfo
        );

        $this->setQuantity($quantity);
        $this->setDeliveryAddress($deliveryAddress);
    }

    /**
     * Set the quantity.
     *
     * @param  mixed $quantity
     * @return $this
     */
    private function setQuantity($quantity)
    {
        if (! is_numeric($quantity)) {
            throw new \InvalidArgumentException("Invalid quantity, must be numeric: $quantity");
        }

        $this->quantity = (int) $quantity;

        return $this;
    }

    /**
     * Set the delivery address.
     *
     * @param  array|DeliveryAddress $deliveryAddress
     * @return $this
     */
    protected function setDeliveryAddress($deliveryAddress)
    {
        if (is_array($deliveryAddress) && ! empty($deliveryAddress)) {
            $deliveryAddress = DeliveryAddress::fromAssociativeArray($deliveryAddress);
        }

        if (! $deliveryAddress instanceof DeliveryAddress) {
            throw new \InvalidArgumentException("Invalid deliveryAddress, you must pass an instance of DeliveryAddress or an array that can be converted.");
        }

        $this->deliveryAddress = $deliveryAddress;

        return $this;
    }
}
