<?php

namespace Ignite\Vendor\Hawk\Tests\Response;

use Ignite\Vendor\Hawk\EGiftIndividualOrderLine;
use Ignite\Vendor\Hawk\EmailContent;
use Ignite\Vendor\Hawk\PaymentType;
use Ignite\Vendor\Hawk\PersonalizedOrderLine;
use Ignite\Vendor\Hawk\Request\SubmitEGiftIndividualRequest;
use Ignite\Vendor\Hawk\Request\SubmitOpenLoopPersonalizedIndividualRequest;
use PHPUnit\Framework\TestCase;

class SubmitOpenLoopPersonalizedIndividualRequestTest extends TestCase
{
    /** @var array */
    private $recipientFixture = [
        'firstName' => 'John',
        'lastName' => 'Smith',
        'address' => [
            'line1' => '102 Decker Dr',
            'city' => 'Irving',
            'region' => 'TX',
            'postalCode' => '75062',
            'country' => 'USA',
            'line2' => 'Suite 150',
        ],
        'phoneNumber' => '9726619876',
        'id' => '1',
        'email' => 'johnsmith@gmail.com',
    ];

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group Reloadable
     */
    public function it_provides_the_correct_array_data_for_request()
    {
        $input = [
            'orderDetails' => [
                PersonalizedOrderLine::fromAssociativeArray([
                    'recipient' => $this->recipientFixture,
                    'amount' => 25.0,
                    'shippingMethod' => \Ignite\Vendor\Hawk\ShippingMethod::USPS_STANDARD_MAIL,
                    'cardCarrierMessage' => 'Incentive program',
                    'description' => "Reloadable description",
                    'fourthLineEmbossText' => "Branded Message",
                ])
            ],
            'clientProgramNumber'=> '123123123',
            'emailContent' => EmailContent::fromAssociativeArray([
                'senderName' => 'Ignite Platform',
                'senderEmail' => 'it@brightspot.email',
                'subject' => 'Test eGift Subject',
                'emailMessage' => 'Test eGift Message',
                'emailClosingName' => 'Test eGift Closing Name',
                'unsubscribeData' => [
                    'companyName' => 'Brightspot',
                    'addressLine1' => '102 Decker Court',
                    'addressCity' => 'Irving',
                    'addressState' => 'TX',
                    'addressZip' => '75062',
                    'addressCountry' => 'US',
                    'methodType' => 'EMAIL',
                    'value' => 'it@brightspot.email',
                ]
            ]),
            'paymentType' => PaymentType::DRAW_DOWN,
        ];

        $request = new SubmitOpenLoopPersonalizedIndividualRequest(
            $input['orderDetails'],
            $input['clientProgramNumber'],
            $input['paymentType']
        );

        $output = $request->toArray();

        $this->assertInternalType('array', $output['orderDetails']);
        $this->assertNotEmpty($output['orderDetails']);
        $this->assertSame('123123123', $output['clientProgramNumber']);
        $this->assertSame(PaymentType::DRAW_DOWN, $output['paymentType']);
    }
}