<?php

namespace Ignite\Vendor\Hawk\Tests;

use Ignite\Vendor\Hawk\PersonalizedOrderLine;
use PHPUnit\Framework\TestCase;

class PersonalizedOrderLineTest extends TestCase
{
    /** @var array */
    private $recipientFixture = [
        'firstName' => 'John',
        'lastName' => 'Smith',
        'address' => [
            'line1' => '102 Decker Dr',
            'city' => 'Irving',
            'region' => 'TX',
            'postalCode' => '75062',
            'country' => 'USA',
            'line2' => 'Suite 150',
        ],
        'phoneNumber' => '9726619876',
        'id' => '1',
        'email' => 'johnsmith@gmail.com',
    ];

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group Reloadable
     */
    public function it_can_create_an_instance_from_an_associated_array()
    {
        $data = [
            'recipient' => $this->recipientFixture,
            'amount' => 25.0,
            'shippingMethod' => \Ignite\Vendor\Hawk\ShippingMethod::USPS_STANDARD_MAIL,
            'cardCarrierMessage' => 'Incentive program',
            'description' => "Reloadable description",
            'fourthLineEmbossText' => "Branded Message",
        ];

        $orderLine = PersonalizedOrderLine::fromAssociativeArray($data);

        $this->assertInstanceOf(PersonalizedOrderLine::class, $orderLine);

        $this->assertSame($data, $orderLine->toArray());
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group Reloadable
     */
    public function it_fails_when_amount_is_not_numeric()
    {
        PersonalizedOrderLine::fromAssociativeArray([
            'amount' => "moneys",
            'recipient' => $this->recipientFixture,
            'shippingMethod' => \Ignite\Vendor\Hawk\ShippingMethod::USPS_STANDARD_MAIL,
            'cardCarrierMessage' => 'Incentive program',
            'description' => "Reloadable description",
            'fourthLineEmbossText' => "Branded Message",
            'additionalInfo' => []
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group Reloadable
     */
    public function it_fails_when_description_exceeds_character_limit()
    {
        PersonalizedOrderLine::fromAssociativeArray([
            'amount' => '25.0',
            'recipient' => $this->recipientFixture,
            'shippingMethod' => \Ignite\Vendor\Hawk\ShippingMethod::USPS_STANDARD_MAIL,
            'cardCarrierMessage' => 'Incentive program',
            'description' => str_repeat('X', 41),
            'fourthLineEmbossText' => "Branded Message",
            'additionalInfo' => []
        ]);
    }
}
