<?php

namespace Ignite\Vendor\Hawk\Response;

use Illuminate\Contracts\Support\Arrayable;
use Ignite\Vendor\Hawk\ResponseException;
use Psr\Http\Message\ResponseInterface;

/**
 * Class ErrorResponse
 *
 * @method array getErrors()
 * @method bool hasErrors()
 * @method array getAdditionalInfo()
 * @method bool hasAdditionalInfo()
 */
class ErrorResponse extends Response implements Arrayable, ResponseInterface
{
    /** @var array */
    protected $errors;

    /** @var array */
    protected $additionalInfo;

    /**
     * Create an ErrorResponse object from a JSON HTTP response.
     *
     * @param  $response
     *
     * @return ErrorResponse
     * @throws ResponseException
     */
    public static function fromHttpResponse(ResponseInterface $response)
    {
        $data = static::parseJson($response);

        //logger('Response data', $data);

        if (is_array($data) && ! array_key_exists('errors', $data)) {
            $data = ['errors' => $data];
        }

        if (! isset($data['errors'])) {
            throw new ResponseException($response, 'Expected errors in response, unable to locate using key `errors`.');
        }

        return app(static::class, $data)->setHttpResponse($response);
    }

    /**
     * ErrorResponse constructor.
     *
     * @param array $errors
     * @param array $additionalInfo
     */
    public function __construct(array $errors, array $additionalInfo = [])
    {
        $this->errors = $errors;
        $this->additionalInfo = $additionalInfo;
    }
}
