<?php

namespace Ignite\Vendor\Hawk\Request;

use Illuminate\Contracts\Support\Arrayable;
use Ignite\Vendor\Hawk\ClosedLoopIndividualOrderLine;
use Ignite\Vendor\Hawk\PaymentType;

class SubmitClosedLoopIndividualRequest extends Request implements Arrayable
{
    /**
     * @var array
     */
    protected $orderDetails;

    /**
     * @var string
     */
    protected $clientProgramNumber;

    /**
     * @var string
     */
    protected $paymentType;

    /**
     * @var string
     */
    protected $poNumber;

    /**
     * @var null
     */
    protected $creditCardPaymentInformation;

    /**
     * @var null
     */
    protected $thirdPartyInfo;

    /**
     * Create an instance from an associative array of data.
     *
     * @param  array $data
     * @return static
     */
    public static function fromAssociativeArray(array $data)
    {
        return app(static::class, $data);
    }

    /**
     * SubmitClosedLoopIndividualRequest constructor.
     *
     * @param array  $orderDetails
     * @param string $clientProgramNumber
     * @param string $paymentType
     * @param string $poNumber
     * @param null   $creditCardPaymentInformation
     */
    public function __construct(
        array $orderDetails,
        $clientProgramNumber,
        $paymentType = PaymentType::DRAW_DOWN,
        $poNumber = '',
        $creditCardPaymentInformation = null
    ) {
        $this->setOrderDetails($orderDetails);
        $this->clientProgramNumber = $clientProgramNumber;
        $this->paymentType = $paymentType;
        $this->poNumber = $poNumber;
        $this->creditCardPaymentInformation = $creditCardPaymentInformation;
    }

    /**
     * Set the order details.
     *
     * @param  array $orderDetails
     * @return $this
     */
    protected function setOrderDetails($orderDetails)
    {
        $this->orderDetails = array_filter($orderDetails, function($orderLine) {
            return $orderLine instanceof ClosedLoopIndividualOrderLine;
        });

        $this->orderDetails = array_map(function (ClosedLoopIndividualOrderLine $orderLine) {
            return $orderLine->toArray();
        }, $this->orderDetails);

        return $this;
    }
}
