<?php

namespace Ignite\Vendor\Hawk\Request;

use Ignite\Vendor\Hawk\Model;

abstract class Request extends Model
{
    /**
     * The client program number.
     *
     * @param string $clientProgramNumber
     * @return string
     */
    protected function getClientProgramNumber($clientProgramNumber = '')
    {
        $clientProgramNumber = trim($clientProgramNumber);

        if (! empty($clientProgramNumber)) {
            return $clientProgramNumber;
        }

        if (! empty($this->clientProgramNumber)) {
            return $this->clientProgramNumber;
        }

        throw new \DomainException('Unknown `clientProgramNumber` value.');
    }

    /**
     * The client prefix for the request ID to prevent duplicate Request ID values across multiple programs.
     *
     * @param  string $clientPrefix
     * @return string
     */
    /** --- not used
    protected function getClientPrefix($clientPrefix = '')
    {
        $clientPrefix = trim($clientPrefix);

        if (! empty($clientPrefix)) {
            return $clientPrefix;
        }

        if (property_exists($this, 'clientPrefix') && ! empty($this->clientPrefix)) {
            return $this->clientPrefix;
        }

        return config('modules.catalog.vendors.hawk.prefix');
    }
    */
}
