<?php

namespace Ignite\Vendor\Hawk;

use Illuminate\Contracts\Support\Arrayable;

class EGiftIndividualOrderLine extends Model implements Arrayable
{
    /** @var VirtualRecipient */
    protected $recipient;

    /** @var float */
    protected $amount;

    /** @var string */
    protected $contentProvider;

    /** @var string */
    protected $description;

    /** @var array */
    protected $additionalInfo;

    /**
     * Create an instance from an associative array.
     *
     * @param  array $data
     * @return EGiftIndividualOrderLine
     */
    public static function fromAssociativeArray($data)
    {
        return app(static::class, $data);
    }

    /**
     * EgiftIndividualOrderLine constructor.
     *
     * @param array|VirtualRecipient $recipient
     * @param float                  $amount
     * @param null|string            $contentProvider
     * @param null|string            $description
     * @param array                  $additionalInfo
     */
    public function __construct($recipient, $amount, $contentProvider = null, $description = null, $additionalInfo = [])
    {
        $this->setRecipient($recipient);
        $this->setAmount($amount);
        $this->setContentProvider($contentProvider);
        $this->setDescription($description);
        $this->additionalInfo = $additionalInfo;
    }

    /**
     * Set the recipient.
     *
     * @param  array|VirtualRecipient $recipient
     * @return $this
     */
    public function setRecipient($recipient)
    {
        if (is_array($recipient) && ! empty($recipient)) {
            $recipient = app(VirtualRecipient::class, $recipient);
        }

        if (! $recipient instanceof VirtualRecipient) {
            throw new \InvalidArgumentException("Invalid recipient, you must pass an instance of VirtualRecipient or an array that can be converted.");
        }

        $this->recipient = $recipient;

        return $this;
    }

    /**
     * Set the amount.
     *
     * @param  mixed $amount
     * @return $this
     */
    private function setAmount($amount)
    {
        if (! is_numeric($amount)) {
            throw new \InvalidArgumentException("Invalid amount, must be numeric: $amount");
        }

        $this->amount = (float) $amount;

        return $this;
    }

    /**
     * Set the content provider.
     *
     * @param  string $contentProvider
     * @return $this
     */
    private function setContentProvider($contentProvider)
    {
        $this->contentProvider = $contentProvider;

        return $this;
    }

    /**
     * Set the fourth line emboss text.
     *
     * @param  string $description
     * @return $this
     */
    private function setDescription($description)
    {
        if (! is_null($description)) {
            $this->guardAgainstMaxLength('description', $description, 40);
        }

        $this->description = $description;

        return $this;
    }
}
