<?php

namespace Ignite\Vendor\Hawk\Response;

use Illuminate\Contracts\Support\Arrayable;
use Psr\Http\Message\ResponseInterface;

/**
 * Class OrderInfoResponse
 *
 * @method string getOrderNumber()
 * @method int getClientProgramNumber()
 * @method string getRequestId()
 * @method string getOrderStatus()
 * @method string getDateSubmitted()
 * @method int getNumberOfCards()
 * @method float getTotalCost()
 */
class OrderInfoResponse extends Response implements Arrayable
{
    /**
     * @var string
     */
    protected $orderNumber;

    /**
     * @var int
     */
    protected $clientProgramNumber;

    /**
     * @var string
     */
    protected $requestId;

    /**
     * @var string
     */
    protected $orderStatus;

    /**
     * @var string
     */
    protected $dateSubmitted;

    /**
     * @var int
     */
    protected $numberOfCards;

    /**
     * @var float
     */
    protected $totalCost;

    /**
     * Create an instance from a Http Response.
     *
     * @param  ResponseInterface $response
     * @return OrderInfoResponse|static
     * @throws \Ignite\Vendor\Hawk\ResponseException
     */
    public static function fromHttpResponse(ResponseInterface $response)
    {
        return app(static::class, static::parseJson($response))->setHttpResponse($response);
    }

    /**
     * OrderInfo constructor.
     *
     * @param string $orderNumber
     * @param int    $clientProgramNumber
     * @param string $requestId
     * @param string $orderStatus
     * @param string $dateSubmitted
     * @param int    $numberOfCards
     * @param float  $totalCost
     */
    public function __construct(
        $orderNumber = null,
        $clientProgramNumber = null,
        $requestId = null,
        $orderStatus = null,
        $dateSubmitted = null,
        $numberOfCards = null,
        $totalCost = null
    ) {
        $this->orderNumber = $orderNumber;
        $this->clientProgramNumber = $clientProgramNumber;
        $this->requestId = $requestId;
        $this->orderStatus = $orderStatus;
        $this->dateSubmitted = $dateSubmitted;
        $this->numberOfCards = $numberOfCards;
        $this->totalCost = $totalCost;
    }
}
