<?php

namespace Ignite\Vendor\Hawk\Request;

use Ignite\Vendor\Hawk\ClosedLoopBulkOrderLine;

class SubmitClosedLoopBulkRequest extends SubmitClosedLoopIndividualRequest
{
    /**
     * Set the order details.
     *
     * @param  array $orderDetails
     * @return $this
     */
    protected function setOrderDetails($orderDetails)
    {
        $this->orderDetails = array_filter($orderDetails, function($orderLine) {
            return $orderLine instanceof ClosedLoopBulkOrderLine;
        });

        $this->orderDetails = array_map(function (ClosedLoopBulkOrderLine $orderLine) {
            return $orderLine->toArray();
        }, $this->orderDetails);

        return $this;
    }
}
