<?php

namespace Ignite\Vendor\Hawk;

class PaymentType extends Model
{
    const CREDIT_CARD = 'CREDIT_CARD';
    const ACH_DEBIT = 'ACH_DEBIT';
    const ACH_CREDIT = 'ACH_CREDIT';
    const WIRE_TRANSFER = 'WIRE_TRANSFER';
    const BUSINESS_CHECK = 'BUSINESS_CHECK';
    const POST_PAY = 'POST_PAY';
    const DRAW_DOWN = 'DRAW_DOWN';

    /**
     * The supported payment methods as an associative array.
     *
     * @return array
     */
    public function toArray()
    {
        return static::getPaymentTypes();
    }

    /**
     * Get the payment types.
     *
     * @return array
     */
    public static function getPaymentTypes()
    {
        return [
            'CREDIT_CARD' => 'CREDIT CARD',
            'ACH_DEBIT' => 'ACH DEBIT',
            'WIRE_TRANSFER' => 'WIRE TRANSFER',
            'BUSINESS_CHECK' => 'BUSINESS CHECK',
            'ACH_CREDIT' => 'ACH CREDIT',
            'POST_PAY' => 'POST PAY',
            'DRAW_DOWN' => 'DRAW DOWN',
        ];
    }
}
