# Changelog

## 1.0.20.1 - 2023-07-26
- Hotfix for Client::orderInfo() where orderNumber can also be 'Unavailable'.

## 1.0.20 - 2023-05-01

### Changes
- Fix `RecipientAddress` and `OpenLoopAnonymousDeliveryAddress` to use the correct max length for region depending on country.

## 1.0.19 - 2023-04-14

### Changes
- Updated `orderInfo()` method in `Client.php`. We can now retrieve order details either by `vendor_order_number` or `clientProgramNumber` and `requestId` using the api endpoint: `rewardsOrderProcessing/v1/orderInfo/byKeys`.
- Added `buildGetRequest()` that builds order info request based on required info provided. ([WDS-3785](https://brightspot.atlassian.net/browse/WDS-3785) | ([WDS-3061](https://brightspot.atlassian.net/browse/WDS-3061)

## 1.0.18 - 2023-01-19

### Changes
- Updates for FundingOrderLine to match the Hawk document, and a few related guards. ([WDS-3588](https://brightspot.atlassian.net/browse/WDS-3588))
- We've decided we wanted to sanitize the phoneNumber before sending for PersonalizedRecipient.
- In OpenLoopAnonymousDeliveryAddress, we decided it would be better to guardAgainstMaxLength for address lines instead of auto-truncating them. This forces users to put in addresses on separate lines instead of all in one line and then get truncated at something important.
- Enable debug mode for Client when in test mode.

## 1.0.17 - 2022-12-06

### Changes
- Added transformExceedingMaxLength() to truncate values that are exceeds the max length allowed by Hawk's API.
  Recommended for values that are flexible and can be truncated (after a certain length) and still send "mostly"
  the right data. Others should use guardAgainstMaxLength() where they can revise for correction. ([WDS-3012](https://brightspot.atlassian.net/browse/WDS-3012))
- Added setX methods to OpenLoopAnonymousDeliveryAddress and OpenSubmitLoopAnonymousBulkOrderLine to be more consistent
  like the others (like ClosedLoopIndividualOrderLine and PersonalizedOrderLine).

## 1.0.16 - 2022-05-06

### Changes
- Added SubmitOpenLoopAnonymousBulk Prepaid API End Point

## 1.0.14 - 2022-05-05

### Changes
- Added CHANGELOG.md
- Updated Shipping Methods to reflect Brightspot's current default shipping methods ([WDS-2580](https://brightspot.atlassian.net/jira/software/c/projects/BSDP/boards/28?modal=detail&selectedIssue=WDS-2580))
