<?php

namespace Ignite\Vendor\Hawk\Request;

use Ignite\Vendor\Hawk\PaymentType;
use Ignite\Vendor\Hawk\PersonalizedOrderLine;

class SubmitOpenLoopPersonalizedIndividualRequest extends Request
{
    /**
     * @var array
     */
    protected $orderDetails;

    /**
     * @var string
     */
    protected $clientProgramNumber;

    /**
     * @var string
     */
    protected $paymentType;

    /**
     * @var string
     */
    protected $poNumber;

    /**
     * @var null
     */
    protected $creditCardPaymentInformation;

    /**
     * @var null
     */
    protected $thirdPartyInfo;

    /**
     * Create an instance from an associative array of data.
     *
     * @param  array $data
     * @return static
     */
    public static function fromAssociativeArray(array $data)
    {
        return app(static::class, $data);
    }

    /**
     * SubmitClosedLoopAnonymousRequest constructor.
     *
     * @param array      $orderDetails
     * @param string     $clientProgramNumber
     * @param string     $paymentType
     * @param string     $poNumber
     * @param null|array $creditCardPaymentInformation
     * @param null"array $thirdPartyInfo
     */
    public function __construct(
        array $orderDetails,
        $clientProgramNumber,
        $paymentType = PaymentType::DRAW_DOWN,
        $poNumber = '',
        $creditCardPaymentInformation = null,
        $thirdPartyInfo = null
    ) {
        $this->setOrderDetails($orderDetails);
        $this->clientProgramNumber = $clientProgramNumber;
        $this->paymentType = $paymentType;
        $this->poNumber = $poNumber;
        $this->creditCardPaymentInformation = $creditCardPaymentInformation;
        $this->thirdPartyInfo = $thirdPartyInfo;
    }

    /**
     * Set the order details.
     *
     * @param  array $orderDetails
     * @return $this
     */
    protected function setOrderDetails($orderDetails)
    {
        $this->orderDetails = array_filter($orderDetails, function($orderLine) {
            return $orderLine instanceof PersonalizedOrderLine;
        });

        $this->orderDetails = array_map(function (PersonalizedOrderLine $orderLine) {
            return $orderLine->toArray();
        }, $this->orderDetails);

        return $this;
    }
}
