<?php

namespace Ignite\Vendor\Hawk;

use Illuminate\Contracts\Support\Arrayable;

class ClosedLoopAnonymousOrderLine extends Model implements Arrayable
{
    /**
     * @var string
     */
    protected $amount;

    /**
     * @var string
     */
    protected $quantity;

    /**
     * @var DeliveryAddress
     */
    protected $deliveryAddress;

    /**
     * @var string
     */
    protected $contentProvider;

    /**
     * @var string
     */
    protected $id;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var string
     */
    protected $shippingMethod;

    /**
     * @var string
     */
    protected $cardCarrierMessage;

    /**
     * @var string
     */
    protected $fourthLineEmbossText;

    /**
     * @var array
     */
    protected $additionalInfo;

    /**
     * Create an instance from an associative array, assuming that array has the required keys.
     *
     * @param  array $data
     * @return static
     */
    public static function fromAssociativeArray(array $data)
    {
        return app(static::class, $data);
    }

    /**
     * ClosedLoopAnonymousOrderLine constructor.
     *
     * @param string                $amount
     * @param string                $quantity
     * @param array|DeliveryAddress $deliveryAddress
     * @param string                $contentProvider
     * @param string                $id
     * @param string                $description
     * @param string                $shippingMethod
     * @param string                $cardCarrierMessage
     * @param string                $fourthLineEmbossText
     * @param array                 $additionalInfo
     */
    public function __construct(
        $amount,
        $quantity,
        $deliveryAddress,
        $contentProvider = '',
        $id = '',
        $description = '',
        $shippingMethod = ShippingMethod::USPS_STANDARD_MAIL,
        $cardCarrierMessage = '',
        $fourthLineEmbossText = '',
        array $additionalInfo = []
    ) {
        $this->amount = $amount;
        $this->quantity = $quantity;
        $this->setDeliveryAddress($deliveryAddress);
        $this->contentProvider = $contentProvider;
        $this->id = $id;
        $this->description = $description;
        $this->shippingMethod = $shippingMethod;
        $this->cardCarrierMessage = $cardCarrierMessage;
        $this->fourthLineEmbossText = $fourthLineEmbossText;
        $this->additionalInfo = $additionalInfo;
    }

    /**
     * Set the delivery address.
     *
     * @param  array|DeliveryAddress $deliveryAddress
     * @return $this
     */
    protected function setDeliveryAddress($deliveryAddress)
    {
        if (is_array($deliveryAddress) && ! empty($deliveryAddress)) {
            $deliveryAddress = DeliveryAddress::fromAssociativeArray($deliveryAddress);
        }

        if (! $deliveryAddress instanceof DeliveryAddress) {
            throw new \InvalidArgumentException("Invalid deliveryAddress, you must pass an instance of DeliveryAddress or an array that can be converted.");
        }

        $this->deliveryAddress = $deliveryAddress;

        return $this;
    }
}
