<?php

namespace Ignite\Vendor\Hawk\Tests\Response;

use Ignite\Vendor\Hawk\ResponseException;
use Ignite\Vendor\Hawk\Response\ErrorResponse;
use PHPUnit\Framework\TestCase;
use Psr\Http\Message\ResponseInterface;

class ErrorResponseTest extends TestCase
{
    /**
     * @var array
     */
    protected $data = [
        'errors' => [
            ['The first error']
        ],
        'additionalInfo' => [
            ['The first info']
        ]
    ];

    /**
     * Set up the test.
     *
     * @return void
     */
    public function setUp()
    {
        parent::setUp();
    }

    /**
     * Tear down the test.
     *
     * @return void
     */
    public function tearDown()
    {
        //$this->resetDatabase();
        parent::tearDown();
    }

    /**
     * @test
     * @group Api
     * @group Vendor
     */
    public function it_can_transform_response_body_into_an_error_response_object()
    {
        $mock = \Mockery::mock(ResponseInterface::class);
        $mock->shouldReceive('getBody')->andReturn(json_encode($this->data));

        $response = ErrorResponse::fromHttpResponse($mock);

        $this->assertSame($this->data, $response->toArray());
        $this->assertTrue($response->hasErrors());
    }

    /**
     * @test
     * @group Api
     * @group Vendor
     */
    public function it_will_throw_an_set_the_data_as_errors_if_the_response_has_no_errors_key()
    {
        $data = $this->data;

        unset($data['errors']);

        $data['foo'] = 'bar';

        $mock = \Mockery::mock(ResponseInterface::class);
        $mock->shouldReceive('getStatusCode')->andReturn(200);
        $mock->shouldReceive('getReasonPhrase')->andReturn('');
        $mock->shouldReceive('getBody')->andReturn(json_encode($data));

        $response = ErrorResponse::fromHttpResponse($mock);

        $this->assertArrayHasKey('foo', $response->getErrors());
    }

    /**
     * @test
     * @group Api
     * @group Vendor
     */
    public function it_can_return_errors()
    {
        $response = new ErrorResponse($this->data['errors']);

        $this->assertEquals($this->data['errors'], $response->getErrors());
    }

    /**
     * @test
     * @group Api
     * @group Vendor
     */
    public function it_can_return_additional_info()
    {
        $response = new ErrorResponse($this->data['errors'], $this->data['additionalInfo']);

        $this->assertEquals($this->data['additionalInfo'], $response->getAdditionalInfo());
    }
}