# Changelog

## 1.0.17 - 2022-12-06

### Changes
- Added transformExceedingMaxLength() to truncate values that are exceeds the max length allowed by Hawk's API.
  Recommended for values that are flexible and can be truncated (after a certain length) and still send "mostly"
  the right data. Others should use guardAgainstMaxLength() where they can revise for correction. ([WDS-3012](https://brightspot.atlassian.net/browse/WDS-3012))
- Added setX methods to OpenLoopAnonymousDeliveryAddress and OpenSubmitLoopAnonymousBulkOrderLine to be more consistent
  like the others (like ClosedLoopIndividualOrderLine and PersonalizedOrderLine).

## 1.0.16 - 2022-05-06

### Changes
- Added SubmitOpenLoopAnonymousBulk Prepaid API End Point

## 1.0.14 - 2022-05-05

### Changes
- Added CHANGELOG.md
- Updated Shipping Methods to reflect Brightspot's current default shipping methods ([WDS-2580](https://brightspot.atlassian.net/jira/software/c/projects/BSDP/boards/28?modal=detail&selectedIssue=WDS-2580))

### Upgrading
- If experiencing issues with `orderDetails.shippingMethod.invalid` check the catalog configuration file to ensure the shipping methods match the following defaults in Hawk Marketplace for the specified endpoint and Hawk product id. Refer to Hawk's [documentation](https://developer.blackhawknetwork.com/hawkmarketplace/docs/welcome)
```php
app\config\catalog.php

[
    ...
    'vendors' => [
        'hawk' => [
            'prepaid' => [
                ...
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
            ],
            'reloadable' => [
                ...
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
            ],
    ...
]
```
