<?php

namespace Ignite\Vendor\Hawk\Request;

use Ignite\Vendor\Hawk\PaymentType;
use Illuminate\Contracts\Support\Arrayable;

class SubmitClosedLoopAnonymousRequest extends SubmitClosedLoopIndividualRequest implements Arrayable
{
    /**
     * @var null
     */
    protected $thirdPartyInfo;

    /**
     * SubmitClosedLoopAnonymousRequest constructor.
     *
     * @param array  $orderDetails
     * @param string $clientProgramNumber
     * @param string $paymentType
     * @param string $poNumber
     * @param null   $creditCardPaymentInformation
     * @param null   $thirdPartyInfo
     */
    public function __construct(
        array $orderDetails,
        $clientProgramNumber,
        $paymentType = PaymentType::DRAW_DOWN,
        $poNumber = '',
        $creditCardPaymentInformation = null,
        $thirdPartyInfo = null
    ) {
        parent::__construct($orderDetails, $clientProgramNumber, $paymentType, $poNumber, $creditCardPaymentInformation);
        $this->thirdPartyInfo = $thirdPartyInfo;
    }
}
