<?php

namespace Ignite\Vendor\Hawk;

use Illuminate\Contracts\Support\Arrayable;

class OpenSubmitLoopAnonymousBulkOrderLine extends Model implements Arrayable
{
    /**
     * @var int
     */
    protected $amount;

    /**
     * @var int
     */
    protected $quantity;

    /**
     * @var DeliveryAddress
     */
    protected $deliveryAddress;

    /**
     * @var string
     */
    protected $contentProvider;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var string
     */
    protected $clientRefId;

    /**
     * @var string
     */
    protected $shippingMethod;

    /**
     * @var string
     */
    protected $cardCarrierMessage;

    /**
     * @var string
     */
    protected $fourthLineEmbossText;

    /**
     * @var array
     */
    protected $additionalInfo;

    /**
     * Create an instance from an associative array, assuming that array has the required keys.
     *
     * @param array $data
     * @return static
     */
    public static function fromAssociativeArray(array $data)
    {
        return app(static::class, $data);
    }

    /**
     * ClosedLoopAnonymousOrderLine constructor.
     * @param int $amount
     * @param array|DeliveryAddress $deliveryAddress
     * @param int $quantity
     * @param string|null $description
     * @param string|null $clientRefId
     * @param string|null $fourthLineEmbossText
     * @param string|null $cardCarrierMessage
     * @param string $shippingMethod
     * @param array $additionalInfo
     */
    public function __construct(
        int $amount,
        $deliveryAddress,
        int $quantity,
        $description = '',
        $clientRefId = '',
        $fourthLineEmbossText = '',
        $cardCarrierMessage = '',
        string $shippingMethod = ShippingMethod::UPS_GROUND,
        array $additionalInfo = []

    )
    {
        $this->amount = $amount;
        $this->setDeliveryAddress($deliveryAddress);
        $this->quantity = $quantity;
        $this->description = $description;
        $this->clientRefId = $clientRefId;
        $this->fourthLineEmbossText = $fourthLineEmbossText;
        $this->cardCarrierMessage = $cardCarrierMessage;
        $this->shippingMethod = $shippingMethod;
        $this->additionalInfo = $additionalInfo;
    }

    /**
     * Set the delivery address.
     *
     * @param array|OpenLoopAnonymousDeliveryAddress $deliveryAddress
     * @return $this
     */
    protected function setDeliveryAddress($deliveryAddress)
    {
        if (is_array($deliveryAddress) && !empty($deliveryAddress)) {
            $deliveryAddress = OpenLoopAnonymousDeliveryAddress::fromAssociativeArray($deliveryAddress);
        }

        if (!$deliveryAddress instanceof OpenLoopAnonymousDeliveryAddress) {
            throw new \InvalidArgumentException("Invalid deliveryAddress, you must pass an instance of DeliveryAddress or an array that can be converted.");
        }

        $this->deliveryAddress = $deliveryAddress;

        return $this;
    }
}
