#Changelog

F: New Feature / Enhancement
B: Breaking
X: Bug Fix

# 1.0.15/16 - 2022-05-06

- [F] Added SubmitOpenLoopAnonymousBulk Prepaid API End Point

## 1.0.14 - 2022-05-05

### Changes
- Added CHANGELOG.md
- Updated Shipping Methods to reflect Brightspot's current default shipping methods ([WDS-2580](https://brightspot.atlassian.net/jira/software/c/projects/BSDP/boards/28?modal=detail&selectedIssue=WDS-2580))

### Upgrading
- If experiencing issues with `orderDetails.shippingMethod.invalid` check the catalog configuration file to ensure the shipping methods match the following defaults in Hawk Marketplace for the specified endpoint and Hawk product id. Refer to Hawk's [documentation](https://developer.blackhawknetwork.com/hawkmarketplace/docs/welcome)
```php
app\config\catalog.php

[
    ...
    'vendors' => [
        'hawk' => [
            'prepaid' => [
                ...
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
            ],
            'reloadable' => [
                ...
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
            ],
    ...
]
```
