<?php

namespace Ignite\Vendor\Hawk;

use Illuminate\Contracts\Support\Arrayable;

/**
 * Delivery Address Model.
 *
 * @method string getCompany()
 * @method string getFirstName()
 * @method string getLastName()
 * @method string getLine1()
 * @method string getLine2()
 * @method string getLine3()
 * @method string getCity()
 * @method string getRegion()
 * @method string getPostalCode()
 * @method string getCountry()
 * @method string getPostalCodeExt()
 * @method string hasCompany()
 * @method string hasLine1()
 * @method string hasLine2()
 * @method string hasLine3()
 * @method string hasCity()
 * @method string hasRegion()
 * @method string hasPostalCode()
 * @method string hasCountry()
 * @method string hasPostalCodeExt()
 */
class OpenLoopAnonymousDeliveryAddress extends Model implements Arrayable
{
    /**
     * @var string
     */
    protected $company;

    /**
     * @var string
     */
    protected $firstName;

    /**
     * @var string
     */
    protected $lastName;

    /**
     * @var string
     */
    protected $line1;

    /**
     * @var string
     */
    protected $city;

    /**
     * @var string
     */
    protected $region;

    /**
     * @var string
     */
    protected $postalCode;

    /**
     * @var string
     */
    protected $country;

    /**
     * @var string
     */
    protected $line2;

    /**
     * @var string
     */
    protected $line3;

    /**
     * @var string
     */
    protected $postalCodeExt;

    /**
     * Create an instance from an associative array, assuming that array has the required keys.
     *
     * @param array $data
     * @return $this
     */
    public static function fromAssociativeArray($data)
    {
        return app(static::class, $data);
    }

    /**
     * DeliveryAddress constructor.
     *
     * @param string $company
     * @param string $firstName
     * @param string $lastName
     * @param string $line1
     * @param string $city
     * @param string $region
     * @param string $postalCode
     * @param string $country
     * @param string|null $line2
     * @param string|null $line3
     * @param string|null $postalCodeExt
     */
    public function __construct(
        string $company,
        string $firstName,
        string $lastName,
        string $line1,
        string $city,
        string $region,
        string $postalCode,
        string $country,
        $line2 = '',
        $line3 = '',
        $postalCodeExt = null
    )
    {
        $this->company = $company;
        $this->firstName = $firstName;
        $this->lastName = $lastName;
        $this->line1 = $line1;
        $this->city = $city;
        $this->region = $region;
        $this->postalCode = $postalCode;
        $this->country = $country;
        $this->line2 = $line2;
        $this->line3 = $line3;
        $this->postalCodeExt = $postalCodeExt;
    }
}
