<?php

namespace Ignite\Vendor\Hawk\Request;

use Ignite\Vendor\Hawk\EmailContent;
use Ignite\Vendor\Hawk\PaymentType;
use Ignite\Vendor\Hawk\PersonalizedOrderLine;
use Ignite\Vendor\Hawk\VirtualIndividualOrderLine;

class SubmitVirtualIndividualRequest extends Request
{
    /**
     * @var array
     */
    protected $orderDetails;

    /**
     * @var string
     */
    protected $clientProgramNumber;

    /**
     * @var EmailContent
     */
    protected $emailContent;

    /**
     * @var string
     */
    protected $paymentType;

    /**
     * @var string
     */
    protected $poNumber;

    /**
     * @var null
     */
    protected $creditCardPaymentInformation;

    /**
     * @var null
     */
    protected $thirdPartyInfo;

    /**
     * Create an instance from an associative array of data.
     *
     * @param  array $data
     * @return static
     */
    public static function fromAssociativeArray(array $data)
    {
        return app(static::class, $data);
    }

    /**
     * SubmitClosedLoopAnonymousRequest constructor.
     *
     * @param array      $orderDetails
     * @param string     $clientProgramNumber
     * @param array|EmailContent $emailContent
     * @param string     $paymentType
     * @param string     $poNumber
     * @param null|array $creditCardPaymentInformation
     * @param null"array $thirdPartyInfo
     */
    public function __construct(
        array $orderDetails,
        $clientProgramNumber,
        $emailContent,
        $paymentType = PaymentType::DRAW_DOWN,
        $poNumber = '',
        $creditCardPaymentInformation = null,
        $thirdPartyInfo = null
    ) {
        $this->setOrderDetails($orderDetails);
        $this->clientProgramNumber = $clientProgramNumber;
        $this->setEmailContent($emailContent);
        $this->paymentType = $paymentType;
        $this->poNumber = $poNumber;
        $this->creditCardPaymentInformation = $creditCardPaymentInformation;
        $this->thirdPartyInfo = $thirdPartyInfo;
    }

    /**
     * Set the order details.
     *
     * @param  array $orderDetails
     * @return $this
     */
    protected function setOrderDetails($orderDetails)
    {
        $this->orderDetails = array_filter($orderDetails, function($orderLine) {
            return $orderLine instanceof VirtualIndividualOrderLine;
        });

        $this->orderDetails = array_map(function (VirtualIndividualOrderLine $orderLine) {
            return $orderLine->toArray();
        }, $this->orderDetails);

        return $this;
    }

    /**
     * Set the email content.
     *
     * @param  array|EmailContent $emailContent
     * @return $this
     */
    public function setEmailContent($emailContent)
    {
        if (is_array($emailContent) && ! empty($emailContent)) {
            $emailContent = app(EmailContent::class);
        }

        if (! $emailContent instanceof EmailContent) {
            throw new \InvalidArgumentException(
                "Invalid emailContent, you must pass an instance of EmailContent or an array that can be converted."
            );
        }

        $this->emailContent = $emailContent;

        return $this;
    }
}
