<?php

namespace Ignite\Vendor\Hawk\Response;

use Ignite\Vendor\Hawk\Request\SubmitEGiftIndividualRequest;

/**
 * Class SubmitEGiftIndividualTransactionResponse
 *
 * @method string getStartTime()
 * @method string getCompletionTime()
 * @method string getVersionId()
 * @method string getStatus()
 * @method bool getIsReversible()
 * @method bool getWasReversed()
 * @method array getContext()
 * @method int getStepsCompleted()
 * @method bool getSteps()
 */
class SubmitEGiftIndividualTransactionResponse extends TransactionResponse
{
    /**
     * The SubmitEGiftIndividualResponse instance.
     *
     * @return SubmitEgiftIndividualResponse
     */
    public function getResponse()
    {
        return app(SubmitEGiftIndividualResponse::class, $this->data['response']);
    }

    /**
     * The SubmitEGiftIndividualResponse instance.
     *
     * @return SubmitEGiftIndividualRequest
     */
    public function getRequest()
    {
        return app(SubmitEGiftIndividualRequest::class, $this->data['request']);
    }
}
