<?php

namespace Ignite\Vendor\Hawk\Tests;

use Ignite\Vendor\Hawk\ClosedLoopIndividualOrderLine;
use PHPUnit\Framework\TestCase;

class ClosedLoopIndividualOrderLineTest extends TestCase
{
    private $recipientFixture = [
        'firstName' => 'John',
        'lastName' => 'Smith',
        'address' => [
            'line1' => '102 Decker Ct',
            'city' => 'Irving',
            'region' => 'TX',
            'postalCode' => '75062',
            'country' => 'USA',
        ]
    ];

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_create_an_instance_from_an_associated_array()
    {
        $this->assertInstanceOf(ClosedLoopIndividualOrderLine::class, ClosedLoopIndividualOrderLine::fromAssociativeArray([
            'amount' => 25,
            'contentProvider' => 'Target',
            'recipient' => $this->recipientFixture
        ]));
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_amount_is_not_numeric()
    {
        ClosedLoopIndividualOrderLine::fromAssociativeArray([
            'amount' => "moneys",
            'contentProvider' => 'Target',
            'recipient' => $this->recipientFixture
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_shipping_method_is_unrecognized()
    {
        ClosedLoopIndividualOrderLine::fromAssociativeArray([
            'amount' => 25,
            'contentProvider' => 'Target',
            'shippingMethod' => "MAKEY_UPPEY_METHOD",
            'recipient' => $this->recipientFixture
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_groupingid_exceeds_character_limit()
    {
        ClosedLoopIndividualOrderLine::fromAssociativeArray([
            'amount' => 25,
            'contentProvider' => 'Target',
            'groupingId' => str_repeat('X', 51),
            'recipient' => $this->recipientFixture
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_description_exceeds_character_limit()
    {
        ClosedLoopIndividualOrderLine::fromAssociativeArray([
            'amount' => 25,
            'contentProvider' => 'Target',
            'description' => str_repeat('X', 41),
            'recipient' => $this->recipientFixture
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_cardcarriermessage_exceeds_character_limit()
    {
        ClosedLoopIndividualOrderLine::fromAssociativeArray([
            'amount' => 25,
            'contentProvider' => 'Target',
            'cardCarrierMessage' => str_repeat('X', 81),
            'recipient' => $this->recipientFixture
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_fourthlineembosstext_exceeds_character_limit()
    {
        ClosedLoopIndividualOrderLine::fromAssociativeArray([
            'amount' => 25,
            'contentProvider' => 'Target',
            'fourthLineEmbossText' => str_repeat('X', 22),
            'recipient' => $this->recipientFixture
        ]);
    }
}
