<?php

namespace Ignite\Vendor\Hawk\Tests;

use Ignite\Vendor\Hawk\Ssl;
use org\bovigo\vfs\vfsStream;
use org\bovigo\vfs\vfsStreamDirectory;
use PHPUnit\Framework\TestCase;

class SslTest extends TestCase
{
    /** @var vfsStreamDirectory */
    private $root;

    /** @var string */
    private $certpath = 'certs/brightspot.cert.pem';

    /** @var string */
    private $keypath = 'certs/brightspot.key';

    /**
     * Set up test environmemt
     */
    public function setUp()
    {
        $this->root = vfsStream::setup('storage');
    }
    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_store_and_retrieve_references_to_paths_to_ssl_cert_and_key_files_on_disk()
    {
        vfsStream::newFile($this->certpath)->at($this->root)->setContent("The cert file");
        vfsStream::newFile($this->keypath)->at($this->root)->setContent("The key file");

        $data = [
            'certPath' => vfsStream::url('storage/' . $this->certpath),
            'keyPath' => vfsStream::url('storage/' . $this->keypath),
        ];

        $ssl = new Ssl($data['certPath'], $data['keyPath']);

        $this->assertSame([$data['certPath'], $data['keyPath']], $ssl->forHttpClient());
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_throws_an_exception_when_the_certPath_argument_is_invalid()
    {
        vfsStream::newFile($this->certpath)->at($this->root)->setContent("The cert file");
        vfsStream::newFile($this->keypath)->at($this->root)->setContent("The key file");

        $data = [
            'certPath' => $this->certpath,
            'keyPath' => vfsStream::url('storage/' . $this->keypath),
        ];

        new Ssl($data['certPath'], $data['keyPath']);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_throws_an_exception_when_the_keyPath_argument_is_invalid()
    {
        vfsStream::newFile($this->certpath)->at($this->root)->setContent("The cert file");
        vfsStream::newFile($this->keypath)->at($this->root)->setContent("The key file");

        $data = [
            'certPath' => vfsStream::url('storage/' . $this->certpath),
            'keyPath' => $this->keypath,
        ];

        new Ssl($data['certPath'], $data['keyPath']);
    }
}
