<?php

namespace Ignite\Flash;

use Illuminate\Support\ServiceProvider;

class FlashServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/ignite-flash.php', 'ignite-flash');
        $this->loadViewsFrom(__DIR__ . '/../views/', 'ignite-flash');
        $this->publishes([
            realpath(__DIR__ . '/../views') => resource_path('views/vendor/ignite-flash.php'),
            realpath(__DIR__ . '/../config/ignite-flash.php') => config_path('ignite-flash.php')
        ], 'ignite-flash');
    }

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('flash', function () {
            return $this->app->make(MessageHandler::class);
        });
    }

    /**
     * Provides the flash handler.
     *
     * @return array
     */
    public function provides()
    {
        return ['flash'];
    }
}
