<?php

namespace Ignite\Flash;

use Illuminate\Contracts\Session\Session;

class SessionStore implements StoreInterface
{
    /**
     * @var Session
     */
    private $session;

    /**
     * SessionStore constructor.
     *
     * @param Session $session
     */
    public function __construct(Session $session)
    {
        $this->session = $session;
    }

    /**
     * Flash a message to the session.
     *
     * @param string $level
     * @param array|object $message
     * @return void
     */
    public function flash($level, $message)
    {
        $this->session->flash($level, $message);
    }
}
