<?php

namespace Ignite\Flash;

use Illuminate\Contracts\Container\Container;

class MessageFactory
{
    /**
     * @var Container
     */
    private $container;

    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * Create an instance of a Message.
     *
     * @param string $message
     * @param string $level
     *
     * @return Message
     */
    public function make($message, $level)
    {
        return $this->container->make(Message::class, compact('message', 'level'));
    }
}
