<?php

namespace Ignite\Flash\Facades;

use Illuminate\Support\Facades\Facade;

/**
 * The Flash facade is the main point of entry.
 *
 * @method \Ignite\Flash\MessageHandler add(string $message, string $level)
 * @method \Ignite\Flash\MessageHandler info(string $message)
 * @method \Ignite\Flash\MessageHandler error(string $message)
 * @method \Ignite\Flash\MessageHandler warning(string $message)
 * @method \Ignite\Flash\MessageHandler success(string $message)
 */
class Flash extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'flash';
    }
}
