<?php

namespace Ignite\Flash;

use Illuminate\Support\ServiceProvider;

class FlashServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/ignite-flash.php', 'ignite-flash');
        $this->loadViewsFrom(__DIR__ . '/../views', 'ignite-flash');
        $this->publishes([
            __DIR__ . '/../views/message.blade.php' => resource_path('views/vendor/flash'),
            __DIR__ . '/../config/ignite-flash.php' => config_path('ignite-flash')
        ], 'ignite-flash');
    }

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('flash', function () {
            return $this->app->make(MessageHandler::class);
        });
    }

    /**
     * Provides the flash handler.
     *
     * @return array
     */
    public function provides()
    {
        return ['flash'];
    }
}
