<?php

namespace Ignite\Flash;

use Illuminate\Contracts\Config\Repository;
use Illuminate\Support\Traits\Macroable;

class Message
{
    use Macroable;

    const LEVEL_INFO = 'info';
    const LEVEL_WARNING = 'warning';
    const LEVEL_SUCCESS = 'success';
    const LEVEL_ERROR = 'error';

    /**
     * The level indicator.
     *
     * @var string
     */
    private $level;

    /**
     * The flash message.
     *
     * @var string
     */
    private $message;

    /**
     * The config repository.
     *
     * @var Repository
     */
    private $config;

    /**
     * Create a new flash message instance.
     *
     * @param string $level
     * @param string $message
     * @param Repository $config
     */
    public function __construct(string $level, string $message, Repository $config)
    {
        $this->level = $level;
        $this->message = $message;
        $this->config = $config;
    }

    /**
     * The level indicator.
     *
     * @return string
     */
    public function getLevel()
    {
        return $this->level;
    }

    /**
     * The flash message.
     *
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * The alias for the level.
     *
     * @return string
     */
    public function getAlias()
    {
        $aliases = $this->config->get('ignite-flash.levels.aliases', []);

        if (! array_key_exists($this->level, $aliases)) {
            return $this->getLevel();
        }

        return $aliases[$this->level];
    }
}
