<?php

namespace Ignite\Flash\Test;

use Ignite\Flash\MessageHandler;
use Illuminate\Contracts\Session\Session;

class FlashTest extends TestCase
{
    /** @var Session */
    protected $session;

    /** @var MessageHandler */
    protected $flash;

    /**
     * Setup the test environment.
     *
     * @return void
     */
    public function setUp()
    {
        parent::setUp();

        $this->session = app(Session::class);
        $this->flash = new MessageHandler($this->session);
    }

    /**
     * @test
     */
    public function it_checks_session_on_info_message_and_level()
    {
        $this->flash->info('Information');

        $this->assertSame('Information', $this->session->get('ignite.flash.message'));
        $this->assertSame(MessageHandler::LEVEL_INFO, $this->session->get('ignite.flash.level'));
    }

    /**
     * @test
     */
    public function it_checks_session_on_warning_message_and_level()
    {
        $this->flash->warning('Warning!');

        $this->assertSame('Warning!', $this->session->get('ignite.flash.message'));
        $this->assertSame(MessageHandler::LEVEL_WARNING, $this->session->get('ignite.flash.level'));
    }

    /**
     * @test
     */
    public function it_checks_session_on_error_message_and_level()
    {
        $this->flash->error('Error!');

        $this->assertSame('Error!', $this->session->get('ignite.flash.message'));
        $this->assertSame(MessageHandler::LEVEL_ERROR, $this->session->get('ignite.flash.level'));
    }

    /**
     * @test
     */
    public function it_checks_session_on_success_message_and_level()
    {
        $this->flash->success('Successful!');

        $this->assertSame('Successful!', $this->session->get('ignite.flash.message'));
        $this->assertSame(MessageHandler::LEVEL_SUCCESS, $this->session->get('ignite.flash.level'));
    }

    /**
     * @test
     */
    public function it_checks_session_on_message_on_custom()
    {
        $this->flash->message('message', 'foo');

        $this->assertSame('message', $this->session->get('ignite.flash.message'));
        $this->assertSame('foo', $this->session->get('ignite.flash.level'));
    }
}
