<?php

namespace Ignite\Flash;

use Illuminate\Support\ServiceProvider;

class FlashServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadViewsFrom(__DIR__ . '/../views', 'flash');

        $this->publishes([
            __DIR__ . '/../views/message.blade.php' => resource_path('views/vendor/flash')
        ], 'flash');
    }

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('flash', function () {
            return $this->app->make(MessageHandler::class);
        });
    }

    /**
     * Provides the flash handler.
     *
     * @return array
     */
    public function provides()
    {
        return ['flash'];
    }
}
