# Ignite Flash Messaging Package

## Installation

Install via composer:

```json
{
    "require": {
       "ignite/flash": "^1.0"
    },
    "repositories": {
        "flash": {
            "type": "vcs",
            "url": "git@bitbucket.org:brightspot-packages/flash.git"
        }
    }
}
```

## Usage:

In your controller:

```php
public function index() 
{
    flash()->info('Flash information!');
}
```
 
The entire API:

```php
flash()->success('Flash success!');
flash()->warning('Flash warning!');
flash()->error('Flash error!');
flash()->message('Message to flash', 'info');
```

When the message is flashed to the session, it can then be displayed your views using the following blade directive: 

```php
@include('flash::message')
```

If you want the flash alert message to fade out, add the following jQuery to your layout/view template, typically in the 'js' section:

```javascript
$(document).ready(function () {
    $('.alert').delay(8000).fadeOut();
});
```

### Publishing views to customize the flash message

```bash
php artisan vendor:publish --tag=flash
```

`message.blade.php` will be copied to `resources/views/vendor/flash`
