<?php

namespace Ignite\Demo\Traits;

trait ParticipantTypesTrait
{
    /**
     * The list of participant types
     * @var array
     */
    protected $types = [
        0 => 'Account Executive',
        1 => 'Sales Engineer',
    ];

    /**
     * Get a random participant type.
     *
     * @param  int $min
     * @param  int $max
     * @return mixed
     */
    protected function getRandomType($min = 0, $max = 1)
    {
        return $this->types[rand($min, $max)];
    }
}
